<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For SQLite, we need to use raw SQL to update the CHECK constraint
        DB::statement("
            CREATE TABLE bills_new (
                id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                society_id INTEGER NOT NULL,
                bill_cycle_id INTEGER,
                user_id INTEGER NOT NULL,
                bill_no VARCHAR NOT NULL,
                amount NUMERIC NOT NULL,
                maintenance NUMERIC NOT NULL DEFAULT 0,
                water NUMERIC NOT NULL DEFAULT 0,
                electricity NUMERIC NOT NULL DEFAULT 0,
                parking NUMERIC NOT NULL DEFAULT 0,
                other_charges NUMERIC NOT NULL DEFAULT 0,
                gst NUMERIC NOT NULL DEFAULT 0,
                discount NUMERIC NOT NULL DEFAULT 0,
                status VARCHAR CHECK (status IN ('draft', 'under_review', 'pending', 'approved', 'due', 'paid', 'overdue', 'cancelled')) NOT NULL DEFAULT 'draft',
                due_date DATE NOT NULL,
                paid_at DATE,
                generated_by INTEGER,
                revised_by INTEGER,
                revised_at DATETIME,
                revision_note TEXT,
                receipt_path VARCHAR,
                created_at DATETIME,
                updated_at DATETIME,
                deleted_at DATETIME,
                FOREIGN KEY(society_id) REFERENCES societies(id) ON DELETE CASCADE,
                FOREIGN KEY(bill_cycle_id) REFERENCES bill_cycles(id) ON DELETE SET NULL,
                FOREIGN KEY(user_id) REFERENCES users(id) ON DELETE CASCADE,
                FOREIGN KEY(generated_by) REFERENCES users(id) ON DELETE SET NULL,
                FOREIGN KEY(revised_by) REFERENCES users(id) ON DELETE SET NULL
            )
        ");
        
        DB::statement("INSERT INTO bills_new SELECT * FROM bills");
        DB::statement("DROP TABLE bills");
        DB::statement("ALTER TABLE bills_new RENAME TO bills");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Reverse not implemented for safety
    }
};
