<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For SQLite, we might need to disable foreign key constraints temporarily
        // But since we are just changing a column definition (or check constraint), it depends on the driver.
        // Laravel's Schema builder 'change()' method requires doctrine/dbal.
        // A safer bet for SQLite enum changes is often raw SQL or recreating the table.
        // However, simply changing it to 'string' removes the enum constraint, allowing any value.
        // Let's try to modify it to include the new value.
        
        Schema::table('bills', function (Blueprint $table) {
            // We redefine the enum with the new value. 
            // Note: This might not work perfectly on SQLite without recreating the table if it enforces CHECK constraints strictly.
            // But often in Laravel + SQLite, enums are just Varchars.
            // Let's try to update it.
            $table->enum('status', ['draft', 'under_review', 'pending', 'approved', 'due', 'paid', 'overdue', 'cancelled'])->default('draft')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bills', function (Blueprint $table) {
            $table->enum('status', ['draft', 'due', 'paid', 'overdue', 'cancelled'])->default('due')->change();
        });
    }
};
