<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add type to buildings table (Works in SQLite)
        Schema::table('buildings', function (Blueprint $table) {
            $table->string('type')->default('building')->after('name');
        });

        // Modify units table enums (Skip for SQLite as it's loosely typed)
        if (DB::getDriverName() !== 'sqlite') {
            DB::statement("ALTER TABLE units MODIFY COLUMN type ENUM('apartment', 'shop', 'office', 'parking', 'flat', 'bungalow') DEFAULT 'apartment'");
            DB::statement("ALTER TABLE units MODIFY COLUMN status ENUM('vacant', 'occupied', 'maintenance', 'rented') DEFAULT 'vacant'");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert buildings table change
        Schema::table('buildings', function (Blueprint $table) {
            $table->dropColumn('type');
        });

        // Revert units table enums
        if (DB::getDriverName() !== 'sqlite') {
            DB::statement("ALTER TABLE units MODIFY COLUMN type ENUM('apartment', 'shop', 'office', 'parking') DEFAULT 'apartment'");
            DB::statement("ALTER TABLE units MODIFY COLUMN status ENUM('vacant', 'occupied', 'maintenance') DEFAULT 'vacant'");
        }
    }
};
