<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('visitors', function (Blueprint $table) {
            // Check if columns don't exist before adding
            if (! Schema::hasColumn('visitors', 'type')) {
                $table->enum('type', ['guest', 'delivery', 'service', 'staff'])->default('guest')->after('email');
            }
            if (! Schema::hasColumn('visitors', 'gatepass_code')) {
                $table->string('gatepass_code', 8)->unique()->nullable()->after('vehicle_number');
            }
            if (! Schema::hasColumn('visitors', 'notes')) {
                $table->text('notes')->nullable()->after('status');
            }
        });

        // Add index if it doesn't exist (using raw SQL for SQLite compatibility)
        // Note: DB::select() is safe here - using hardcoded string, no user input
        try {
            $indexExists = DB::select("SELECT name FROM sqlite_master WHERE type='index' AND name='visitors_phone_status_index'");
            if (empty($indexExists)) {
                Schema::table('visitors', function (Blueprint $table) {
                    $table->index(['phone', 'status'], 'visitors_phone_status_index');
                });
            }
        } catch (\Exception $e) {
            // Index might already exist or table might not support this, continue
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('visitors', function (Blueprint $table) {
            $columns = ['type', 'gatepass_code', 'notes'];

            foreach ($columns as $column) {
                if (Schema::hasColumn('visitors', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
