<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('announcements', function (Blueprint $table) {
            // Check if columns don't exist before adding
            if (! Schema::hasColumn('announcements', 'type')) {
                $table->enum('type', ['info', 'urgent', 'event', 'maintenance', 'payment'])->default('info')->after('content');
            }
            if (! Schema::hasColumn('announcements', 'target_roles')) {
                $table->json('target_roles')->nullable()->after('priority');
            }
            if (! Schema::hasColumn('announcements', 'target_units')) {
                $table->json('target_units')->nullable()->after('target_roles');
            }
            if (! Schema::hasColumn('announcements', 'start_date')) {
                $table->dateTime('start_date')->nullable()->after('target_units');
            }
            if (! Schema::hasColumn('announcements', 'end_date')) {
                $table->dateTime('end_date')->nullable()->after('start_date');
            }
            if (! Schema::hasColumn('announcements', 'require_acknowledgement')) {
                $table->boolean('require_acknowledgement')->default(false)->after('end_date');
            }
            if (! Schema::hasColumn('announcements', 'attachments')) {
                $table->json('attachments')->nullable()->after('require_acknowledgement');
            }
            if (! Schema::hasColumn('announcements', 'views_count')) {
                $table->integer('views_count')->default(0)->after('attachments');
            }
            if (! Schema::hasColumn('announcements', 'acknowledged_count')) {
                $table->integer('acknowledged_count')->default(0)->after('views_count');
            }
        });

        // Add index if it doesn't exist (using raw SQL for SQLite compatibility)
        // Note: DB::select() is safe here - using hardcoded string, no user input
        try {
            $indexExists = DB::select("SELECT name FROM sqlite_master WHERE type='index' AND name='announcements_society_id_type_index'");
            if (empty($indexExists)) {
                Schema::table('announcements', function (Blueprint $table) {
                    $table->index(['society_id', 'type'], 'announcements_society_id_type_index');
                });
            }
        } catch (\Exception $e) {
            // Index might already exist or table might not support this, continue
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('announcements', function (Blueprint $table) {
            $columns = [
                'type',
                'target_roles',
                'target_units',
                'start_date',
                'end_date',
                'require_acknowledgement',
                'attachments',
                'views_count',
                'acknowledged_count',
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('announcements', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
