<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->string('name');
            $table->string('category'); // electrician, plumber, carpenter, painter, etc.
            $table->string('phone');
            $table->string('whatsapp')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->decimal('visit_charge', 8, 2)->default(0);
            $table->decimal('hourly_rate', 8, 2)->default(0);
            $table->float('rating', 3, 2)->default(0); // 0.00 to 5.00
            $table->integer('jobs_completed')->default(0);
            $table->boolean('is_preferred')->default(false);
            $table->boolean('is_active')->default(true);
            $table->json('documents')->nullable(); // License, insurance, etc.
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['society_id', 'category']);
            $table->index(['society_id', 'is_preferred']);
            $table->index('rating');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendors');
    }
};
