<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('announcements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->string('title');
            $table->longText('content');
            $table->enum('type', ['info', 'urgent', 'event', 'maintenance', 'payment'])->default('info');
            $table->enum('priority', ['normal', 'important', 'urgent'])->default('normal');
            $table->json('target_roles')->nullable(); // ["resident", "guard"]
            $table->json('target_units')->nullable(); // [101, 102]
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->boolean('require_acknowledgement')->default(false);
            $table->json('attachments')->nullable();
            $table->integer('views_count')->default(0);
            $table->integer('acknowledged_count')->default(0);
            $table->boolean('is_published')->default(false);
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['society_id', 'is_published']);
            $table->index(['society_id', 'type']);
            $table->index('start_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('announcements');
    }
};
