<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visitors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete(); // Resident who approved
            $table->string('name');
            $table->string('phone');
            $table->string('email')->nullable();
            $table->enum('type', ['guest', 'delivery', 'service', 'staff'])->default('guest');
            $table->string('purpose');
            $table->integer('no_of_visitors')->default(1);
            $table->string('vehicle_number')->nullable();
            $table->string('gatepass_code', 8)->unique()->nullable();
            $table->timestamp('entry_time')->nullable();
            $table->timestamp('exit_time')->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected', 'checked_in', 'checked_out'])->default('pending');
            $table->text('notes')->nullable();
            $table->foreignId('checked_in_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();

            $table->index(['society_id', 'status']);
            $table->index(['user_id', 'entry_time']);
            $table->index(['phone', 'status']);
            $table->index('entry_time');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visitors');
    }
};
