<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bill_cycles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->string('name'); // "January 2025"
            $table->year('year');
            $table->date('generate_date');
            $table->date('due_date');
            $table->enum('status', ['draft', 'generated', 'closed'])->default('draft');
            $table->timestamps();

            $table->index(['society_id', 'year']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bill_cycles');
    }
};
