<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Add plan_id reference
            $table->foreignId('plan_id')->nullable()->after('society_id')->constrained('subscription_plans')->nullOnDelete();

            // Add start_date and end_date if not exists
            if (! Schema::hasColumn('subscriptions', 'start_date')) {
                $table->date('start_date')->after('trial_end_date');
            }

            if (! Schema::hasColumn('subscriptions', 'end_date')) {
                $table->date('end_date')->nullable()->after('start_date');
            }

            // Make plan_name, plan_display_name nullable (will be removed later)
            // Keep them for now for backward compatibility
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropForeign(['plan_id']);
            $table->dropColumn('plan_id');
        });
    }
};
