<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();

            // Plan Identity
            $table->string('name')->unique(); // basic, premium, enterprise
            $table->string('display_name'); // Basic Plan, Premium Plan, Enterprise Plan
            $table->text('description')->nullable();

            // Pricing
            $table->decimal('monthly_price', 10, 2);
            $table->decimal('quarterly_price', 10, 2)->nullable();
            $table->decimal('annual_price', 10, 2)->nullable();

            // Features & Limits
            $table->integer('max_users')->default(100);
            $table->integer('max_units')->default(500);
            $table->integer('max_buildings')->default(10);
            $table->integer('storage_gb')->default(5);

            // Feature Flags
            $table->boolean('sms_enabled')->default(false);
            $table->boolean('whatsapp_enabled')->default(false);
            $table->boolean('email_enabled')->default(true);
            $table->boolean('fcm_enabled')->default(true);
            $table->boolean('advanced_reports')->default(false);
            $table->boolean('api_access')->default(false);
            $table->boolean('custom_branding')->default(false);
            $table->boolean('priority_support')->default(false);
            $table->boolean('white_label')->default(false);

            // Status
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);

            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index('is_active');
            $table->index('sort_order');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};
