<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('society_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();
            $table->unique('society_id'); // One settings record per society

            // ========== PAYMENT GATEWAY SETTINGS ==========
            $table->enum('payment_gateway', ['razorpay', 'stripe', 'payu', 'cashfree', 'none'])->default('none');

            // Razorpay
            $table->string('razorpay_key_id')->nullable();
            $table->string('razorpay_key_secret')->nullable();
            $table->boolean('razorpay_enabled')->default(false);

            // Stripe
            $table->string('stripe_public_key')->nullable();
            $table->string('stripe_secret_key')->nullable();
            $table->boolean('stripe_enabled')->default(false);

            // PayU
            $table->string('payu_merchant_key')->nullable();
            $table->string('payu_merchant_salt')->nullable();
            $table->boolean('payu_enabled')->default(false);

            // Cashfree
            $table->string('cashfree_app_id')->nullable();
            $table->string('cashfree_secret_key')->nullable();
            $table->boolean('cashfree_enabled')->default(false);

            // ========== BROADCAST SETTINGS ==========
            // Email Settings
            $table->boolean('email_enabled')->default(true);
            $table->string('email_provider')->default('smtp'); // smtp, sendgrid, mailgun
            $table->string('smtp_host')->nullable();
            $table->integer('smtp_port')->nullable();
            $table->string('smtp_username')->nullable();
            $table->string('smtp_password')->nullable();
            $table->string('smtp_encryption')->nullable(); // tls, ssl
            $table->string('from_email')->nullable();
            $table->string('from_name')->nullable();

            // SMS Settings
            $table->boolean('sms_enabled')->default(false);
            $table->string('sms_provider')->nullable(); // twilio, msg91, textlocal
            $table->string('sms_api_key')->nullable();
            $table->string('sms_sender_id')->nullable();
            $table->string('sms_username')->nullable();
            $table->string('sms_password')->nullable();

            // WhatsApp Settings
            $table->boolean('whatsapp_enabled')->default(false);
            $table->string('whatsapp_provider')->nullable(); // twilio, gupshup, wati
            $table->string('whatsapp_api_key')->nullable();
            $table->string('whatsapp_sender_id')->nullable();
            $table->string('whatsapp_business_id')->nullable();

            // FCM Settings
            $table->boolean('fcm_enabled')->default(true);
            $table->string('fcm_server_key')->nullable();
            $table->string('fcm_sender_id')->nullable();

            // ========== GENERAL SETTINGS ==========
            $table->string('timezone')->default('Asia/Kolkata');
            $table->string('currency')->default('INR');
            $table->string('date_format')->default('d/m/Y');
            $table->string('time_format')->default('H:i');
            $table->string('language')->default('en');

            // ========== NOTIFICATION SETTINGS ==========
            $table->boolean('notify_bill_generated')->default(true);
            $table->boolean('notify_payment_received')->default(true);
            $table->boolean('notify_visitor_arrival')->default(true);
            $table->boolean('notify_maintenance_request')->default(true);
            $table->boolean('notify_announcement')->default(true);

            // ========== FEATURE TOGGLES ==========
            $table->boolean('enable_visitor_management')->default(true);
            $table->boolean('enable_maintenance_tickets')->default(true);
            $table->boolean('enable_complaints')->default(true);
            $table->boolean('enable_events')->default(true);
            $table->boolean('enable_documents')->default(true);
            $table->boolean('enable_directory')->default(true);
            $table->boolean('enable_notices')->default(true);
            $table->boolean('enable_polls')->default(false);
            $table->boolean('enable_marketplace')->default(false);

            // ========== SECURITY SETTINGS ==========
            $table->boolean('require_otp_for_login')->default(false);
            $table->boolean('require_otp_for_payment')->default(false);
            $table->integer('session_timeout_minutes')->default(120);
            $table->boolean('enable_2fa')->default(false);

            // ========== INTEGRATION SETTINGS ==========
            $table->string('google_analytics_id')->nullable();
            $table->string('facebook_pixel_id')->nullable();
            $table->text('custom_css')->nullable();
            $table->text('custom_js')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('society_settings');
    }
};
