<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('society_id')->constrained('societies')->cascadeOnDelete();

            // Plan Details
            $table->string('plan_name'); // basic, premium, enterprise
            $table->string('plan_display_name'); // Basic Plan, Premium Plan, Enterprise Plan
            $table->decimal('monthly_price', 10, 2);
            $table->decimal('annual_price', 10, 2)->nullable();
            $table->enum('billing_cycle', ['monthly', 'quarterly', 'annual'])->default('monthly');

            // Subscription Status
            $table->enum('status', ['active', 'trial', 'expired', 'cancelled', 'suspended'])->default('trial');
            $table->date('trial_start_date')->nullable();
            $table->date('trial_end_date')->nullable();
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->date('next_billing_date')->nullable();

            // Payment Gateway
            $table->string('payment_gateway')->nullable(); // razorpay, stripe, payu, etc.
            $table->string('gateway_subscription_id')->nullable();
            $table->string('gateway_customer_id')->nullable();

            // Features & Limits
            $table->integer('max_users')->default(100);
            $table->integer('max_units')->default(500);
            $table->integer('max_buildings')->default(10);
            $table->boolean('sms_enabled')->default(false);
            $table->boolean('whatsapp_enabled')->default(false);
            $table->boolean('email_enabled')->default(true);
            $table->boolean('fcm_enabled')->default(true);
            $table->boolean('advanced_reports')->default(false);
            $table->boolean('api_access')->default(false);
            $table->integer('storage_gb')->default(5);

            // Auto-renewal
            $table->boolean('auto_renew')->default(true);
            $table->timestamp('cancelled_at')->nullable();
            $table->text('cancellation_reason')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['society_id', 'status']);
            $table->index('next_billing_date');
            $table->index('end_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
