<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('societies', function (Blueprint $table) {
            if (! Schema::hasColumn('societies', 'suspension_start_date')) {
                $table->date('suspension_start_date')->nullable()->after('status');
            }

            if (! Schema::hasColumn('societies', 'suspension_end_date')) {
                $table->date('suspension_end_date')->nullable()->after('suspension_start_date');
            }

            if (! Schema::hasColumn('societies', 'suspension_reason')) {
                $table->text('suspension_reason')->nullable()->after('suspension_end_date');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('societies', function (Blueprint $table) {
            if (Schema::hasColumn('societies', 'suspension_start_date')) {
                $table->dropColumn('suspension_start_date');
            }

            if (Schema::hasColumn('societies', 'suspension_end_date')) {
                $table->dropColumn('suspension_end_date');
            }

            if (Schema::hasColumn('societies', 'suspension_reason')) {
                $table->dropColumn('suspension_reason');
            }
        });
    }
};
