<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('society_id')->nullable()->after('id')->constrained('societies')->cascadeOnDelete();
            $table->foreignId('role_id')->after('society_id')->constrained('roles')->cascadeOnDelete();
            $table->string('phone')->unique()->after('email');
            $table->unsignedBigInteger('unit_id')->nullable()->after('password');
            $table->string('fcm_token')->nullable()->after('unit_id');
            $table->enum('status', ['active', 'inactive', 'suspended'])->default('active')->after('fcm_token');

            // Make email nullable for mobile users who might only use phone
            $table->string('email')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['society_id']);
            $table->dropForeign(['role_id']);
            $table->dropColumn(['society_id', 'role_id', 'phone', 'unit_id', 'fcm_token', 'status']);
            $table->string('email')->nullable(false)->change();
        });
    }
};
