<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('societies', function (Blueprint $table) {
            $table->id();

            // Basic Society Info
            $table->string('name');
            $table->string('registration_no')->unique();
            $table->text('address');
            $table->string('city');
            $table->string('state', 50);
            $table->string('pincode', 10);

            // Admin & Platform Links
            $table->foreignId('platform_user_id')->nullable()->constrained('users')->nullOnDelete();

            // Financial & Status
            $table->decimal('platform_fee_amount', 10, 2)->default(2500);
            $table->enum('platform_fee_frequency', ['monthly', 'quarterly', 'annual'])->default('monthly');
            $table->enum('status', ['pending', 'active', 'suspended', 'inactive'])->default('pending');

            // Branding & Docs
            $table->string('logo')->nullable();
            $table->string('gst_no')->nullable();
            $table->string('pan_no')->nullable();
            $table->text('rules')->nullable();

            // Legacy fields (keeping for backward compatibility)
            $table->string('code')->nullable()->unique();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();

            // Timestamps & Soft Delete
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index(['status', 'created_at']);
            $table->index('platform_user_id');
            $table->index('registration_no');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('societies');
    }
};
