<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Visitor>
 */
class VisitorFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'user_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'resident'], ['display_name' => 'Resident']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'name' => $this->faker->name,
            'phone' => $this->faker->phoneNumber,
            'vehicle_number' => strtoupper($this->faker->bothify('??-##-??-####')),
            'type' => $this->faker->randomElement(['guest', 'delivery', 'service']), // 'cab' is not in enum
            'purpose' => $this->faker->sentence,
            'entry_time' => now(),
            'status' => 'checked_in',
            'gatepass_code' => $this->faker->unique()->bothify('??####'), // 8 chars max
        ];
    }
}
