<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Vendor>
 */
class VendorFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'name' => $this->faker->company,
            'category' => $this->faker->randomElement(['plumbing', 'electrical', 'carpentry', 'painting', 'cleaning', 'security', 'other']),
            'phone' => $this->faker->phoneNumber,
            'whatsapp' => $this->faker->optional()->phoneNumber,
            'email' => $this->faker->optional()->companyEmail,
            'address' => $this->faker->optional()->address,
            'visit_charge' => $this->faker->numberBetween(200, 1000),
            'hourly_rate' => $this->faker->numberBetween(300, 2000),
            'rating' => $this->faker->randomFloat(1, 3.0, 5.0),
            'jobs_completed' => $this->faker->numberBetween(0, 100),
            'is_preferred' => $this->faker->boolean(30),
            'is_active' => true,
            'notes' => $this->faker->optional()->sentence,
        ];
    }
}
