<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Unit>
 */
class UnitFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'building_id' => null,
            'unit_no' => $this->faker->unique()->bothify('###'),
            'type' => 'apartment',
            'area' => $this->faker->numberBetween(500, 2000),
            'status' => 'occupied',
        ];
    }

    /**
     * Set the building and automatically set society_id from building.
     */
    public function forBuilding(\App\Models\Building $building): static
    {
        return $this->state(fn(array $attributes) => [
            'building_id' => $building->id,
            'society_id' => $building->society_id,
        ]);
    }
}
