<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SubscriptionPlan>
 */
class SubscriptionPlanFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $monthlyPrice = $this->faker->numberBetween(999, 9999);
        $annualPrice = $monthlyPrice * 10; // Annual discount

        return [
            'name' => $this->faker->randomElement(['basic', 'standard', 'premium', 'enterprise']),
            'display_name' => ucfirst($this->faker->randomElement(['Basic', 'Standard', 'Premium', 'Enterprise'])),
            'description' => $this->faker->sentence,
            'monthly_price' => $monthlyPrice,
            'quarterly_price' => $monthlyPrice * 2.5,
            'annual_price' => $annualPrice,
            'max_users' => $this->faker->numberBetween(10, 1000),
            'max_units' => $this->faker->numberBetween(50, 5000),
            'max_buildings' => $this->faker->numberBetween(1, 100),
            'storage_gb' => $this->faker->numberBetween(10, 1000),
            'sms_enabled' => $this->faker->boolean(70),
            'whatsapp_enabled' => $this->faker->boolean(60),
            'email_enabled' => true,
            'fcm_enabled' => true,
            'advanced_reports' => $this->faker->boolean(50),
            'api_access' => $this->faker->boolean(50),
            'custom_branding' => $this->faker->boolean(30),
            'priority_support' => $this->faker->boolean(40),
            'white_label' => $this->faker->boolean(20),
            'is_active' => true,
            'sort_order' => $this->faker->numberBetween(1, 10),
            'validity_days' => $this->faker->numberBetween(30, 365),
        ];
    }
}
