<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Payment>
 */
class PaymentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'bill_id' => \App\Models\Bill::factory(),
            'user_id' => \App\Models\User::factory(),
            'payment_no' => 'PAY-' . $this->faker->unique()->numberBetween(10000, 99999),
            'amount' => $this->faker->numberBetween(1000, 10000),
            'payment_method' => $this->faker->randomElement(['cash', 'online', 'cheque', 'bank_transfer']),
            'payment_date' => now(),
            'transaction_id' => $this->faker->optional()->uuid,
            'status' => $this->faker->randomElement(['pending', 'completed', 'failed', 'cancelled']),
            'notes' => $this->faker->optional()->sentence,
        ];
    }
}
