<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\MaintenanceTicket>
 */
class MaintenanceTicketFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'user_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'resident'], ['display_name' => 'Resident']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'title' => $this->faker->sentence,
            'description' => $this->faker->paragraph,
            'priority' => $this->faker->randomElement(['low', 'medium', 'high', 'urgent']),
            'status' => 'open',
            'ticket_no' => strtoupper($this->faker->unique()->bothify('TKT-####')),
        ];
    }
}
