<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\FacilitySlot>
 */
class FacilitySlotFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startHour = $this->faker->numberBetween(6, 10);
        $endHour = $startHour + $this->faker->numberBetween(2, 4);

        return [
            'facility_id' => \App\Models\Facility::factory(),
            'name' => $this->faker->randomElement(['Morning', 'Afternoon', 'Evening', 'Night']) . ' Slot',
            'start_time' => sprintf('%02d:00:00', $startHour),
            'end_time' => sprintf('%02d:00:00', $endHour),
            'price' => $this->faker->numberBetween(500, 3000),
            'max_bookings_per_slot' => $this->faker->numberBetween(1, 10),
            'is_active' => true,
        ];
    }
}
