<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Facility>
 */
class FacilityFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'name' => $this->faker->randomElement(['Swimming Pool', 'Gym', 'Clubhouse', 'Tennis Court', 'Basketball Court', 'Park', 'Community Hall']),
            'description' => $this->faker->paragraph,
            'capacity' => $this->faker->numberBetween(10, 100),
            'amenities' => $this->faker->words(3),
            'rules' => $this->faker->optional()->paragraph,
            'cancellation_policy' => $this->faker->optional()->sentence,
            'is_active' => true,
            'requires_approval' => $this->faker->boolean(50),
        ];
    }
}
