<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\FacilityBooking>
 */
class FacilityBookingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'facility_id' => \App\Models\Facility::factory(),
            'slot_id' => \App\Models\FacilitySlot::factory(),
            'user_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'resident'], ['display_name' => 'Resident']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'booked_by' => function (array $attributes) {
                return $attributes['user_id'];
            },
            'booking_date' => now()->addDays($this->faker->numberBetween(1, 30)),
            'amount' => $this->faker->numberBetween(500, 5000),
            'payment_status' => $this->faker->randomElement(['pending', 'paid', 'failed', 'refunded']),
            'payment_method' => $this->faker->randomElement(['online', 'cash', 'bank_transfer']),
            'booking_status' => $this->faker->randomElement(['pending', 'confirmed', 'cancelled', 'completed']),
            'purpose' => $this->faker->sentence,
            'guest_count' => $this->faker->numberBetween(1, 20),
        ];
    }
}
