<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Expense>
 */
class ExpenseFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $amount = $this->faker->numberBetween(500, 5000);
        $gstPercentage = 18;
        $gstAmount = ($amount * $gstPercentage) / 100;
        $totalAmount = $amount + $gstAmount;

        return [
            'society_id' => \App\Models\Society::factory(),
            'expense_no' => 'EXP-' . $this->faker->unique()->numberBetween(10000, 99999),
            'amount' => $amount,
            'gst_percentage' => $gstPercentage,
            'gst_amount' => $gstAmount,
            'total_amount' => $totalAmount,
            'category' => $this->faker->randomElement(['maintenance', 'security', 'cleaning', 'electricity', 'water', 'other']),
            'description' => $this->faker->sentence,
            'vendor_name' => $this->faker->company,
            'expense_date' => now(),
            'created_by' => \App\Models\User::factory(),
        ];
    }
}
