<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\EmergencyAlert>
 */
class EmergencyAlertFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'user_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'resident'], ['display_name' => 'Resident']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'unit_id' => \App\Models\Unit::factory(),
            'status' => $this->faker->randomElement(['active', 'resolved', 'false_alarm']),
            'notes' => $this->faker->optional()->sentence,
        ];
    }
}
