<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\CollectorWallet>
 */
class CollectorWalletFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'collector_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'collector'], ['display_name' => 'Collector']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'society_id' => \App\Models\Society::factory(),
            'balance' => $this->faker->numberBetween(0, 50000),
            'total_collected' => $this->faker->numberBetween(100000, 500000),
            'total_handover' => $this->faker->numberBetween(50000, 450000),
        ];
    }
}
