<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Building>
 */
class BuildingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $floors = $this->faker->numberBetween(3, 20);
        $unitsPerFloor = $this->faker->numberBetween(2, 8);

        return [
            'society_id' => \App\Models\Society::factory(),
            'name' => 'Building ' . $this->faker->randomLetter,
            'building_no' => $this->faker->numberBetween(1, 10),
            'floors' => $floors,
            'total_units' => $floors * $unitsPerFloor,
            'address' => $this->faker->optional()->address,
            'type' => $this->faker->randomElement(['apartment', 'villa', 'row_house']),
        ];
    }
}
