<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Bill>
 */
class BillFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'bill_cycle_id' => \App\Models\BillCycle::factory(),
            'user_id' => \App\Models\User::factory(),
            'bill_no' => 'BILL-' . $this->faker->unique()->numberBetween(10000, 99999),
            'amount' => $this->faker->numberBetween(1000, 10000),
            'maintenance' => $this->faker->numberBetween(1000, 5000),
            'water' => $this->faker->numberBetween(100, 500),
            'electricity' => $this->faker->numberBetween(500, 2000),
            'parking' => $this->faker->numberBetween(100, 500),
            'other_charges' => 0,
            'gst' => 0,
            'discount' => 0,
            'status' => 'due',
            'due_date' => now()->addDays(15),
        ];
    }
}
