<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BillCycle>
 */
class BillCycleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'name' => $this->faker->monthName . ' ' . $this->faker->year,
            'year' => $this->faker->year,
            'generate_date' => now(),
            'due_date' => now()->addDays(15),
            'status' => 'generated',
        ];
    }
}
