<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\BankAccount>
 */
class BankAccountFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'account_name' => $this->faker->company . ' Society Account',
            'account_number' => $this->faker->numerify('##########'),
            'ifsc_code' => $this->faker->bothify('????0####?'),
            'bank_name' => $this->faker->randomElement(['State Bank of India', 'HDFC Bank', 'ICICI Bank', 'Axis Bank', 'Kotak Mahindra Bank']),
            'branch_name' => $this->faker->city . ' Branch',
            'balance' => $this->faker->numberBetween(10000, 1000000),
            'account_type' => $this->faker->randomElement(['savings', 'current', 'fixed_deposit']),
            'is_primary' => false,
            'description' => $this->faker->optional()->sentence,
        ];
    }
}
