<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Announcement>
 */
class AnnouncementFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => 1, // Will be overridden in tests
            'title' => $this->faker->sentence,
            'content' => $this->faker->paragraph,
            'type' => $this->faker->randomElement(['info', 'urgent', 'event', 'maintenance', 'payment']),
            'priority' => $this->faker->randomElement(['normal', 'important', 'urgent']),
            'start_date' => now(),
            'end_date' => now()->addDays(7),
            'require_acknowledgement' => false,
            'is_published' => true,
            'created_by' => 1, // Will be overridden in tests
        ];
    }
}
