<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Advertisement>
 */
class AdvertisementFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'user_id' => function () {
                $role = \App\Models\Role::firstOrCreate(['name' => 'resident'], ['display_name' => 'Resident']);
                return \App\Models\User::factory()->create(['role_id' => $role->id])->id;
            },
            'slot_id' => \App\Models\AdSlot::factory(),
            'title' => $this->faker->sentence,
            'description' => $this->faker->paragraph,
            'image_url' => $this->faker->imageUrl,
            'link_url' => $this->faker->optional()->url,
            'start_date' => now(),
            'end_date' => now()->addDays($this->faker->numberBetween(7, 30)),
            'status' => $this->faker->randomElement(['pending', 'approved', 'rejected', 'active', 'expired']),
            'amount' => $this->faker->numberBetween(1000, 10000),
        ];
    }
}
