<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AdSlot>
 */
class AdSlotFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'society_id' => \App\Models\Society::factory(),
            'position' => $this->faker->randomElement(['home_banner', 'sidebar', 'footer', 'popup', 'in_app']),
            'name' => $this->faker->words(2, true) . ' Slot',
            'price_per_day' => $this->faker->numberBetween(100, 1000),
            'max_concurrent_ads' => $this->faker->numberBetween(1, 5),
            'status' => true,
        ];
    }
}
