<?php

namespace App\Services\PaymentGateway;

interface PaymentGatewayInterface
{
    /**
     * Get the gateway identifier.
     */
    public function getIdentifier(): string;

    /**
     * Get the gateway display name.
     */
    public function getName(): string;

    /**
     * Check if the gateway is enabled.
     */
    public function isEnabled(): bool;

    /**
     * Get the public key for frontend integration.
     */
    public function getPublicKey(): ?string;

    /**
     * Create a payment order/session.
     *
     * @param float $amount Amount in base currency unit (e.g., rupees, dollars)
     * @param string $currency Currency code (INR, USD, etc.)
     * @param array $metadata Additional data (bill_id, user_id, etc.)
     * @return array ['order_id' => string, 'amount' => int, 'currency' => string, ...]
     */
    public function createOrder(float $amount, string $currency, array $metadata = []): array;

    /**
     * Verify a payment after completion.
     *
     * @param array $paymentData Payment data from frontend callback
     * @return array ['success' => bool, 'payment_id' => string, 'error' => ?string]
     */
    public function verifyPayment(array $paymentData): array;

    /**
     * Get payment details by ID.
     */
    public function getPaymentDetails(string $paymentId): ?array;
}
