<?php

namespace App\Services\Messaging;

/**
 * Interface for WhatsApp gateway providers.
 */
interface WhatsAppGatewayInterface
{
    /**
     * Send WhatsApp message to a phone number.
     */
    public function send(string $phone, string $message): bool;

    /**
     * Send WhatsApp template message.
     */
    public function sendTemplate(string $phone, string $templateName, array $params = []): bool;

    /**
     * Get the gateway identifier.
     */
    public function getIdentifier(): string;
}
