<?php

namespace App\Policies;

use App\Models\Expense;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class ExpensePolicy
{
    /**
     * Perform pre-authorization checks.
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->role?->name === 'super_admin') {
            return true;
        }
        return null;
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->hasPermission('expenses.view');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Expense $model): bool
    {
        return $user->hasPermission('expenses.view') && $user->society_id === $model->society_id;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasPermission('expenses.create');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Expense $model): bool
    {
        return $user->hasPermission('expenses.edit') && $user->society_id === $model->society_id;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Expense $model): bool
    {
        return $user->hasPermission('expenses.delete') && $user->society_id === $model->society_id;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Expense $model): bool
    {
        return $user->hasPermission('expenses.create') && $user->society_id === $model->society_id;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Expense $model): bool
    {
        return $user->hasPermission('expenses.delete') && $user->society_id === $model->society_id;
    }
}
