<?php

namespace App\Notifications;

use App\Models\Comment;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class NewTicketComment extends Notification implements ShouldQueue
{
    use Queueable;

    protected $comment;

    /**
     * Create a new notification instance.
     */
    public function __construct(Comment $comment)
    {
        $this->comment = $comment;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
             'title' => 'New Comment on Ticket #' . ($this->comment->ticket->ticket_no ?? 'Unknown'),
             'message' => 'New reply from ' . ($this->comment->user->name ?? 'User') . ': ' . substr($this->comment->message, 0, 50) . '...',
             'ticket_id' => $this->comment->ticket_id,
             'sender_id' => $this->comment->user_id,
             'type' => 'info'
        ];
    }
}
