<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

use App\Models\Bill;

class BillGenerated extends Notification
{
    use Queueable;

    public $bill;

    /**
     * Create a new notification instance.
     */
    public function __construct(Bill $bill)
    {
        $this->bill = $bill;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        // TODO: Add 'sms', 'whatsapp' based on society settings
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('New Bill Generated - ' . $this->bill->bill_no)
            ->greeting('Hello ' . $notifiable->name . ',')
            ->line('A new bill has been generated for your unit.')
            ->line('Bill Number: ' . $this->bill->bill_no)
            ->line('Amount: ' . number_format($this->bill->amount, 2))
            ->line('Due Date: ' . $this->bill->due_date->format('d M, Y'))
            ->action('View Bill', url('/resident/bills/' . $this->bill->id))
            ->line('Please pay before the due date to avoid late fees.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'bill_id' => $this->bill->id,
            'bill_no' => $this->bill->bill_no,
            'amount' => $this->bill->amount,
            'message' => 'New bill generated: ' . $this->bill->bill_no,
        ];
    }
}
