<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'society_id',
        'name',
        'category',
        'phone',
        'whatsapp',
        'email',
        'address',
        'visit_charge',
        'hourly_rate',
        'rating',
        'jobs_completed',
        'is_preferred',
        'is_active',
        'documents',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'visit_charge' => 'decimal:2',
            'hourly_rate' => 'decimal:2',
            'rating' => 'float',
            'is_preferred' => 'boolean',
            'is_active' => 'boolean',
            'documents' => 'array',
        ];
    }

    /**
     * Get the society that owns the vendor.
     */
    public function society(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }

    /**
     * Get the maintenance tickets assigned to this vendor.
     */
    public function maintenanceTickets(): HasMany
    {
        return $this->hasMany(MaintenanceTicket::class, 'vendor_id');
    }
}
