<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Unit extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'society_id',
        'building_id',
        'unit_no',
        'type',
        'area',
        'status',
        'user_id',
        'maintenance_structure_id',
    ];

    protected function casts(): array
    {
        return [
            'area' => 'decimal:2',
        ];
    }

    /**
     * Get the society that owns the unit.
     */
    public function society(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }

    /**
     * Get the building that owns the unit.
     */
    public function building(): BelongsTo
    {
        return $this->belongsTo(Building::class);
    }

    /**
     * Get the maintenance structure assigned to the unit.
     */
    public function maintenanceStructure(): BelongsTo
    {
        return $this->belongsTo(MaintenanceStructure::class);
    }

    /**
     * Get the user (resident) assigned to the unit.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the residents assigned to the unit.
     */
    public function residents(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(User::class);
    }
}
