<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class PlatformFee extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'society_id',
        'amount',
        'frequency',
        'start_date',
        'end_date',
        'status',
        'payment_method',
        'transaction_id',
        'paid_at',
    ];

    protected function casts(): array
    {
        return [
            'amount' => 'decimal:2',
            'start_date' => 'date',
            'end_date' => 'date',
            'paid_at' => 'datetime',
        ];
    }

    /**
     * Get the society that owns the platform fee.
     */
    public function society(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }
}
