<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class BillCycle extends Model
{
    use HasFactory;

    protected $fillable = [
        'society_id',
        'name',
        'year',
        'generate_date',
        'due_date',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'generate_date' => 'date',
            'due_date' => 'date',
        ];
    }

    /**
     * Get the society that owns the bill cycle.
     */
    public function society(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }

    /**
     * Get the bills for the bill cycle.
     */
    public function bills(): HasMany
    {
        return $this->hasMany(Bill::class);
    }
}
