<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AdSlot extends Model
{
    use HasFactory;

    protected $fillable = [
        'society_id',
        'position',
        'name',
        'price_per_day',
        'max_concurrent_ads',
        'status',
    ];

    protected $casts = [
        'status' => 'boolean',
        'price_per_day' => 'decimal:2',
    ];

    public function society(): BelongsTo
    {
        return $this->belongsTo(Society::class);
    }

    public function advertisements(): HasMany
    {
        return $this->hasMany(Advertisement::class, 'slot_id');
    }
}
