<?php

namespace App\Mail\Subscription;

use App\Models\Society;
use App\Models\Subscription;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SubscriptionExpired extends Mailable
{
    use Queueable, SerializesModels;

    public Society $society;
    public Subscription $subscription;
    public string $appName;

    /**
     * Create a new message instance.
     */
    public function __construct(Society $society, Subscription $subscription)
    {
        $this->society = $society;
        $this->subscription = $subscription;
        $this->appName = config('app.name', 'Societify');
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "🚨 Your Subscription Has Expired",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.subscription.expired',
            with: [
                'society' => $this->society,
                'subscription' => $this->subscription,
                'appName' => $this->appName,
                'renewUrl' => url('/subscription/renew'),
            ],
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
