<?php

namespace App\Mail\Subscription;

use App\Models\Society;
use App\Models\Subscription;
use App\Models\SubscriptionPayment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentReceived extends Mailable
{
    use Queueable, SerializesModels;

    public Society $society;
    public Subscription $subscription;
    public SubscriptionPayment $payment;
    public string $appName;

    /**
     * Create a new message instance.
     */
    public function __construct(Society $society, Subscription $subscription, SubscriptionPayment $payment)
    {
        $this->society = $society;
        $this->subscription = $subscription;
        $this->payment = $payment;
        $this->appName = config('app.name', 'Societify');
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Payment Received - ₹" . number_format($this->payment->amount, 2),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.subscription.payment-received',
            with: [
                'society' => $this->society,
                'subscription' => $this->subscription,
                'payment' => $this->payment,
                'appName' => $this->appName,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}
