<?php

namespace App\Mail\Society;

use App\Models\Society;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class WelcomeSociety extends Mailable
{
    use Queueable, SerializesModels;

    public Society $society;
    public User $admin;
    public ?string $plainPassword;
    public string $appName;
    public string $loginUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(Society $society, User $admin, ?string $plainPassword = null)
    {
        $this->society = $society;
        $this->admin = $admin;
        $this->plainPassword = $plainPassword;
        $this->appName = config('app.name', 'Societify');
        $this->loginUrl = url('/login');
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Welcome to {$this->appName} - Your Society is Registered!",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.society.welcome',
            with: [
                'society' => $this->society,
                'admin' => $this->admin,
                'plainPassword' => $this->plainPassword,
                'appName' => $this->appName,
                'loginUrl' => $this->loginUrl,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
