<?php

namespace App\Mail\Resident;

use App\Models\Bill;
use App\Models\Payment;
use App\Models\Society;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class PaymentConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public Payment $payment;
    public Bill $bill;
    public User $resident;
    public Society $society;

    /**
     * Create a new message instance.
     */
    public function __construct(Payment $payment, Bill $bill, User $resident, Society $society)
    {
        $this->payment = $payment;
        $this->bill = $bill;
        $this->resident = $resident;
        $this->society = $society;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "✅ Payment Received - ₹" . number_format($this->payment->amount, 2),
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.resident.payment-confirmation',
            with: [
                'payment' => $this->payment,
                'bill' => $this->bill,
                'resident' => $this->resident,
                'society' => $this->society,
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
