<?php

namespace App\Mail\Resident;

use App\Models\Bill;
use App\Models\Society;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BillOverdue extends Mailable
{
    use Queueable, SerializesModels;

    public Bill $bill;
    public User $resident;
    public Society $society;
    public int $daysOverdue;

    /**
     * Create a new message instance.
     */
    public function __construct(Bill $bill, User $resident, Society $society, int $daysOverdue)
    {
        $this->bill = $bill;
        $this->resident = $resident;
        $this->society = $society;
        $this->daysOverdue = $daysOverdue;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "🚨 Bill Overdue - {$this->bill->bill_no}",
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.resident.bill-overdue',
            with: [
                'bill' => $this->bill,
                'resident' => $this->resident,
                'society' => $this->society,
                'daysOverdue' => $this->daysOverdue,
                'appUrl' => url('/'),
            ],
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
